/****************************************************************************************[Solver.C]
ManySAT1.0 -- Copyright (c) 2008-2009, based on Minisat2.0

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or
substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT
OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
**************************************************************************************************/

#define MAX_EXTRA_CLAUSES 20000
#define MAX_EXTRA_UNITS   10000


Cooperation::Cooperation(int n, int l){
  
  nbThreads          = n;
  limitExportClauses = l;
  solvers            = new Solver [nbThreads];
  End                = false;
  nbExported         = 0;
  nbBests            = 5;
    
  nbsharedUnitClauses= 0;
  nbsharedClauses    = 0;


  extraClauses       = new Lit**  [nbThreads];
  extraClausesSizes  = new int*   [nbThreads];
  extraUnits         = new Lit*   [nbThreads];
  nbExtraClauses     = new int    [nbThreads];
  nbExtraUnits       = new int    [nbThreads];
  bests              = new Lit*   [nbThreads];


  for(int t = 0; t < nbThreads; t++){
    bests            [t]  = new Lit [nbBests];	
    extraClauses     [t]  = new Lit* [MAX_EXTRA_CLAUSES];
    extraClausesSizes[t]  = new int  [MAX_EXTRA_CLAUSES];
    extraUnits       [t]  = new Lit  [MAX_EXTRA_UNITS];
    nbExtraClauses   [t]  = 0;
    nbExtraUnits     [t]  = 0;
    for(int i = 0; i < nbBests; i++)  bests[t][i] = lit_Undef;
  }
  
}
Cooperation::~Cooperation(){
  
}

void Cooperation::exportUnit(Solver* s, Lit unit){
#pragma omp critical (extraUnit)
  {
    nbsharedUnitClauses++;
    nbExported++;
    s->nbExportedUnits++;
    
    int id = s->threadId;
    
    for(int t = 0; t < nbThreads; t++)
      if(t != id){
	int ind = nbExtraUnits[t];
	if(ind < MAX_EXTRA_UNITS){
	  extraUnits[t][ind].x = unit.x;
	  nbExtraUnits[t]++;
	}
      }
  }
}
void Cooperation::importUnits(Solver* s){
  int id = s->threadId;
  int nb = nbExtraUnits[id];
 
  s->nbImportedUnits = nb;
  
  for(int i = 0; i < nb; i++)
    if(s->value(extraUnits[id][i]) == l_Undef){
      s->uncheckedEnqueue(extraUnits[id][i]);
    }
  nbExtraUnits[id] = 0;
}


void Cooperation::exportClause(Solver* s, vec<Lit>& learnt){
#pragma omp critical (extraClause)
  {	
    nbsharedClauses++;
    int id = s->threadId;
    nbExported++;
    
    for(int t = 0; t < nbThreads; t++)
    
      if(t != id){
	int ind = nbExtraClauses[t];
	if(ind < MAX_EXTRA_CLAUSES){
	  s->nbExportedClauses++;	
	  extraClauses[t][ind]      = new Lit [learnt.size()];
	  extraClausesSizes[t][ind] = learnt.size();
	  
	  for(int j = 0; j < learnt.size(); j++)
	    extraClauses[t][ind][j] = learnt[j];
	  nbExtraClauses[t]++;
	}else; 
      }
  }
}


void Cooperation::importClauses(Solver* s){
#pragma omp critical (extraClause)
  {
    int id = s->threadId;
    int nb = nbExtraClauses[id];
    
    s->nbImportedClauses = nb;
    for(int i = 0; i < nb; i++){
      vec<Lit> lits;
      for(int j = 0; j < extraClausesSizes[id][i]; j++){
	Lit x = extraClauses[id][i][j];
	lits.push(x);
      }
    
      Clause* c2 = Clause_new(lits, true);
      s->learnts.push(c2);
      s->attachClause(*c2);
      s->claBumpActivity(*c2);
      
      delete [] extraClauses[id][i];
    }
    nbExtraClauses[id] = 0;
  }
}


void Cooperation::exportMostInterestingClauses(Solver* s){
#pragma omp critical (extraClause)
  {	
    //sort(s->learnts, reduceDB_lt());
    for (int i = s->learnts.size() / 2; i < s->learnts.size(); i++){
      if(s->learnts[i]->size() <= limitExportClauses){
	int id = s->threadId;
	Clause* c = s->learnts[i];
	int size = c->size();
	nbExported++;
	s->nbExportedClauses++;			
	for(int t = 0; t < nbThreads; t++)
	  if(t != id){
	    int ind = nbExtraClauses[t];
	    if(ind < MAX_EXTRA_CLAUSES){
	      extraClauses[t][ind] = new Lit [size];
	      extraClausesSizes[t][ind] = size;
	      
	      for(int j = 0; j < size; j++){
		Lit l = c->data[j];
		extraClauses[t][ind][j] = l;
	      }
	      nbExtraClauses[t]++;
	    }
	  }
      }
    }
  }
}

void Cooperation::print(){
  
  int total = 0;
  for(int i = 0; i < nbThreads;i++)
    total += solvers[i].nbExportedClauses;
  printf("\nc #exported clauses (<= %i) , nbExportedTotal = %i", limitExportClauses, total);
}




